<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title>coreCMS</title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Email Template | Create
    </h1>
    
    <!-- 
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
      <li class="active">Here</li>
    </ol> 
    -->

  </section>

  <!-- Main content -->
    <section class="content container-fluid">
        
        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>             

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">&times</button>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>         
        
        <div class="box box-primary">

          <?php echo e(Form::open(array('url' => 'email_template/store', 'class' => ''))); ?>

            <div class="box-body">
              <?php if(UserHelper::isAdminUser(Auth::user()->group_id)): ?>
                <div class="row">
                  <div class="col-md-5">
                    <div class="form-group">
                      <label>Company:</label>
                      <select name="company_id" id="company_id" class="form-control">
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>                    
                    </div>
                  </div>

                  <div class="col-md-5">
                    <div class="form-group">
                      <div id="company-users-container"></div>           
                    </div>  
                  </div>
                </div>
              <?php endif; ?>       
              <div class="form-group">
                <label>Name <span class="required">*</span></label>
                <?php echo Form::text('name', old('name') ,['class' => 'form-control', 'required' => '']); ?>                
              </div>  
              <div class="form-group">
                <label>Content <span class="required">*</span></label>                
                <?php echo Form::textarea('content', old('content') ,['class' => 'form-control', 'id' => 'ckeditor', 'required' => '']); ?>
              </div>  
            </div>        
            <!-- /.box-body -->

            <div class="box-footer">
              <button type="submit" class="btn btn-success">Submit</button>
              <a class="btn btn-primary" href="<?php echo e(route('email_template')); ?>">Cancel</a>
            </div>
          <?php echo Form::close(); ?>     

        </div>        

    </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-footer-scripts'); ?>
<script>
  var base_url = '<?php echo url("/"); ?>'; 

  function load_company_users_dropdown() {
      var company_id = $('#company_id').val();
      var c_user_id = 0;
      $('#company-users-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
      var url = base_url + '/contact/ajax_load_company_users'
      $.ajax({
           type: "GET",
           url: url,               
           data: {
              "company_id":company_id,
              'c_user_id':c_user_id
              }, 
           success: function(o)
           {
              $('#company-users-container').html(o);
           }
      });          
  }

  $(function () {
    load_company_users_dropdown();
    
    $('#company_id').change(function () {
      var company_id = $('#company_id').val();
      var c_user_id = 0;
      $('#company-users-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
      var url = base_url + '/contact/ajax_load_company_users'
      $.ajax({
           type: "GET",
           url: url,               
           data: {
              "company_id":company_id,
              'c_user_id':c_user_id
              }, 
           success: function(o)
           {
              $('#company-users-container').html(o);
           }
      }); 
    });

    // Replace the <textarea id="editor1"> with a CKEditor
    // instance, using default configuration.
    CKEDITOR.replace('ckeditor');

  });

</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\coreCMS\resources\views/email_template/create.blade.php ENDPATH**/ ?>