<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title>coreCMS</title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Contacts : Datasource
    </h1>
    
    <ol class="breadcrumb">
      <li><a href="<?php echo e(route('contact')); ?>"><i class="fa fa-dashboard"></i> Contacts</a></li>
      <li class="active">Data Source</li>
    </ol> 

  </section>

  <!-- Main content -->
    <section class="content container-fluid">

        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>    

        <?php echo e(Form::open(array('url' => 'contact_datasource/store', 'class' => '', 'id' => 'add-contact-datasource-form'))); ?>

        <div class="box box-primary">

          <div class="row">
              <div class="col-md-12">
                <div class="box">
                  <div class="box-header with-border">
                      <div class="pull-left">
                          <a href="<?php echo e(route('contact_datasource')); ?>" class="btn btn-primary">
                              <i class="fa fa-plus"></i> Create New
                          </a>
                      </div>                  
                      <div class="pull-left" style="margin-left: 5px;">
                        <select name="contact_source_list" id="contact_source_list" class="form-control select2" style="">
                          <option value="">-</option>
                          <optgroup label="Import">
                            <?php $__currentLoopData = $datasource_import; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <option value="<?php echo e(Hashids::encode($imp->id)); ?>"><?php echo e($imp->source_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </optgroup>
                          <optgroup label="Webform">
                            <?php $__currentLoopData = $datasource_webform; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <option value="<?php echo e(Hashids::encode($webf->id)); ?>"><?php echo e($webf->source_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </optgroup>
                        </select>                                
                      </div>
                  </div>
                </div>
              </div>
          </div>
          <!-- /.row -->          

          <div class="box-body">
            <div class="row">
              <div class="col-md-10">
                <div class="form-group">
                  <label>Source Name <span class="required">*</span></label>
                  <?php echo Form::text('source_name', old('source_name') ,['class' => 'form-control', 'required' => '']); ?>
                </div>
              </div>
            </div>   
            <!-- /.row -->  

            <div class="row">
              <div class="col-md-5">
                <div class="form-group">
                  <label>Type <span class="required"></span></label>
                  <select name="type" class="form-control" id="type">
                    <option value="1">Import</option>
                    <option value="2">Webform</option>
                  </select>                    
                </div>   
              </div>
              <div class="col-md-5">
                <div class="form-group">
                  <label>Campaign <span class="required"></span></label>
                  <select name="compaign_id" class="form-control" id="compaign_id">
                    <option value="0">-</option>
                    <?php $__currentLoopData = $campaign; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $camp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($camp->id); ?>"><?php echo e($camp->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>                    
                </div>  
              </div>
            </div>         
            <!-- /.row --> 

            <div class="row">
              <div class="col-md-5">
                <div class="form-group">
                  <label>Stage <span class="required"></span></label>
                  <select name="stage_id" class="form-control" id="stage_id">
                    <?php $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($stage->id); ?>"><?php echo e($stage->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>                    
                </div>   
              </div>
              <div class="col-md-5">
                <div class="form-group">
                  <div id="stage-status-container"></div>
                </div>
              </div>
            </div>        
            <!-- /.row -->    

          </div>

          <div class="box-footer">
            <button type="submit" class="btn btn-success">Add</button>
            <a class="btn btn-primary" href="<?php echo e(route('contact_datasource')); ?>">Cancel</a>
          </div> 

        </div>    
        <?php echo Form::close(); ?>  

    </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-footer-scripts'); ?>
<script>
  var base_url = '<?php echo url("/"); ?>'; 

  function load_stage_status_dropdown() {
    var stage_id = $('#stage_id').val();
    $('#stage-status-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
    var url = base_url + '/contact_datasource/ajax_load_stage_status'
    $.ajax({
         type: "GET",
         url: url,               
         data: {"stage_id":stage_id}, 
         success: function(o)
         {
            $('#stage-status-container').html(o);
         }
    });
  }

  $(function () {

    load_stage_status_dropdown();
    $('#stage_id').change(function(){
      load_stage_status_dropdown();
    }); 

    $('#contact_source_list').change(function(){
      window.location = base_url + '/contact_datasource/edit/' + $('#contact_source_list').val(); // redirect
    });    

  });

</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\coreCMS\resources\views/contact/datasource/index.blade.php ENDPATH**/ ?>